<?php
defined('_VALID') or die('Restricted Access!');

require $config['BASE_DIR']. '/classes/filter.class.php';
require $config['BASE_DIR']. '/include/compat/json.php';
require $config['BASE_DIR']. '/include/adodb/adodb.inc.php';
require $config['BASE_DIR']. '/include/dbconn.php';

$filter         = new VFilter();
$search_type    = $filter->get('search_type');
if ( $search_type != 'videos' && $search_type != 'photos' && $search_type != 'users' ) {
    $search_type    = 'videos';
}
$search_title   = 'ADVANCED ' .strtoupper($search_type). ' SEARCH';

$sql            = 'SELECT CHID, name FROM channel ORDER BY name ASC';
$rs             = $conn->execute($sql);
$categories     = $rs->getrows();
$sql            = 'SELECT category_id, category_name FROM game_categories ORDER BY category_name ASC';
$rs             = $conn->execute($sql);
$game_categs    = $rs->getrows();

$data           = array('status' => 0, 'code' => '');
$response       = NULL;

ob_start();
ob_implicit_flush(0);
?>
<div class="btitle">
    <div class="btitlel"><h2 id="advanced_search_title"><?php echo $search_title; ?></h2></div>
    <div class="btitler"><a href="#close_advanced_search" id="close_advanced_search">Close</a></div>
    <div class="clear"></div>
</div>
<br />
<div id="search_tabs">
<ul>
    <li><a href="#search_videos" id="search_tab_videos"<?php if($search_type == 'videos'){echo ' class="active"';} ?>>Search Videos</a></li>
    <?php if ( $config['photo_module'] == '1' ) { ?><li><a href="#search_photos" id="search_tab_photos"<?php if($search_type == 'photos'){echo ' class="active"';} ?>>Search Photos</a></li><?php } ?>
    <li><a href="#search_users" id="search_tab_users"<?php if($search_type == 'users'){echo ' class="active"';} ?>>Search Users</a></li>
    <?php if ( $config['game_module'] == '1' ) { ?><li><a href="#search_games" id="search_tab_games"<?php if($search_type == 'games'){echo ' class="active"';} ?>>Search Games</a></li><?php } ?>
</ul>
<div class="clear_left"></div>
</div>
<div id="search_tabs_delimiter"></div>
<div id="search_videos"<?php if ($search_type != 'videos') {echo ' style="display: none;"';} ?>>
    <form name="search_videos_advanced" id="search_advanced_form" method="get" action="<?php echo $config['BASE_URL']; ?>/search">
        <input name="search_type" type="hidden" value="videos" />
        <div class="search_left">
            <div class="separator">
                <label for="search_query_advanced">Search For:</label>
                <input name="search_query" type="text" id="search_query_advanced" />
            </div>
            <div class="separator">
                <label for="search_category">Category:</label>
                <select name="c" id="search_category">                            
                    <option value="">All</option>
                    <?php foreach ( $categories as $category ): ?>
                    <option value="<?php echo $category['CHID']; ?>"><?php echo htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="separator">
                <label for="type">Type:</label>
                <select name="type" id="type">
                    <option value="">All</option>
                    <option value="public">Public</option>
                    <option value="private">Private</option>
                </select>                            
            </div>
        </div>
        <div class="search_right">
            <div class="separator">
                <label for="search_rating">Rating Higher Than:</label>
                <select name="r" id="search_rating">
                    <option value="">Don't Care</option>
                    <option value="1">1</option>
                    <option value="1.5">1.5</option>
                    <option value="2">2</option>
                    <option value="2.5">2.5</option>
                    <option value="3">3</option>
                    <option value="3.5">3.5</option>
                    <option value="4">4</option>
                    <option value="4.5">4.5</option>
                    <option value="5">5</option>
                </select>
            </div>
            <div class="separator">
                <label for="search_min_length">Min Length:</label>
                <select name="min_length" id="search_min_length">
                    <option value="">Don't Care</option>
                    <option value="1">1 hour</option>
                    <option value="50">50 mins</option>
                    <option value="40">40 mins</option>
                    <option value="30">30 mins</option>
                    <option value="20">20 mins</option>
                    <option value="10">10 mins</option>
                    <option value="5">5 mins</option>
                </select>
            </div>
            <div class="separator">
                <label for="search_max_length">Max Length:</label>
                <select name="max_length" id="search_max_length">
                    <option value="">Don't Care</option>
                    <option value="1">1 hour</option>
                    <option value="50">50 mins</option>
                    <option value="40">40 mins</option>
                    <option value="30">30 mins</option>
                    <option value="20">20 mins</option>
                    <option value="10">10 mins</option>
                    <option value="5">5 mins</option>
                </select>
            </div>
        </div>
        <div class="clear"></div>
        <div class="center">
            <input type="submit" value="Search Advanced" class="button" /><br /><br />
        </div>
    </form>
</div>
<div id="search_photos"<?php if ($search_type != 'photos') {echo ' style="display: none;"';} ?>>
    <form name="search_photos_advanced" id="search_photos_advanced_form" method="get" action="<?php echo $config['BASE_URL']; ?>/search">
        <input name="search_type" type="hidden" value="photos" />
        <div class="search_left">
            <div class="separator">
                <label for="search_query_advanced">Search For:</label>
                <input name="search_query" type="text" id="search_query_advanced" />
            </div>
            <div class="separator">
                <label for="search_category">Category:</label>
                <select name="c" id="search_category">                            
                    <option value="">All</option>
                    <?php foreach ( $categories as $category ): ?>
                    <option value="<?php echo $category['CHID']; ?>"><?php echo htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="separator">
                <label for="type">Type:</label>
                <select name="type" id="type">
                    <option value="">All</option>
                    <option value="public">Public</option>
                    <option value="private">Private</option>
                </select>                            
            </div>
        </div>
        <div class="search_right">
            <div class="separator">
                <label for="search_rating">Rating Higher Than:</label>
                <select name="r" id="search_rating">
                    <option value="">Don't Care</option>
                    <option value="1">1</option>
                    <option value="1.5">1.5</option>
                    <option value="2">2</option>
                    <option value="2.5">2.5</option>
                    <option value="3">3</option>
                    <option value="3.5">3.5</option>
                    <option value="4">4</option>
                    <option value="4.5">4.5</option>
                    <option value="5">5</option>
                </select>
            </div>
        </div>
        <div class="clear"></div>
        <div class="center">
            <input type="submit" value="Search Advanced" class="button" /><br /><br />
        </div>
    </form>
</div>
<div id="search_users"<?php if ($search_type != 'users') {echo ' style="display: none;"';} ?>>
    <form name="search_users_advanced" id="search_users_advanced_form" method="get" action="<?php echo $config['BASE_URL']; ?>/search">
        <input name="search_type" type="hidden" value="users" />
        <div class="search_left">
            <div class="separator">
                <label for="search_query_advanced">Search For:</label>
                <input name="search_query" type="text" id="search_query_advanced" />
            </div>
            <div class="separator">
                <label for="search_gender">Gender:</label>
                <select name="g" id="search_gender">
                    <option value="">Any</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                </select>
            </div>
            <div class="separator">
                <label for="search_interested">Interested:</label>
                <select name="i" id="search_interested">
                    <option value="">Any</option>
                    <option value="Guys">Guys</option>
                    <option value="Girls">Girls</option>
                    <option value="Guys+Girls">Guys+Girls</option>
                </select>
            </div>
        </div>
        <div class="search_right">
            <div class="separator">
                <label for="search_rating">Rating Higher Than:</label>
                <select name="r" id="search_rating">
                    <option value="">Don't Care</option>
                    <option value="1">1</option>
                    <option value="1.5">1.5</option>
                    <option value="2">2</option>
                    <option value="2.5">2.5</option>
                    <option value="3">3</option>
                    <option value="3.5">3.5</option>
                    <option value="4">4</option>
                    <option value="4.5">4.5</option>
                    <option value="5">5</option>
                </select>
            </div>
            <div class="separator">
                <label for="search_online">Online: </label>
                <select name="u" id="search_online">
                    <option value="">Don't Care</option>
                    <option value="yes">Yes</option>
                    <option value="no">No</option>
                </select>
            </div>
        </div>
        <div class="clear"></div>
        <div class="center">
            <input type="submit" value="Search Advanced" class="button" /><br /><br />
        </div>
    </form>
</div>
<div id="search_games"<?php if ($search_type != 'games') {echo ' style="display: none;"';} ?>>
    <form name="search_games_advanced" id="search_games_advanced_form" method="get" action="<?php echo $config['BASE_URL']; ?>/search">
        <input name="search_type" type="hidden" value="games" />
        <div class="search_left">
            <div class="separator">
                <label for="search_query_advanced">Search For:</label>
                <input name="search_query" type="text" id="search_query_advanced" />
            </div>
            <div class="separator">
                <label for="search_category">Category:</label>
                <select name="c" id="search_category">                            
                    <option value="">All</option>
                    <?php foreach ( $game_categs as $category ): ?>
                    <option value="<?php echo $category['category_id']; ?>"><?php echo htmlspecialchars($category['category_name'], ENT_QUOTES, 'UTF-8'); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="separator">
                <label for="type">Type:</label>
                <select name="type" id="type">
                    <option value="">All</option>
                    <option value="public">Public</option>
                    <option value="private">Private</option>
                </select>                            
            </div>
        </div>
        <div class="search_right">
            <div class="separator">
                <label for="search_rating">Rating Higher Than:</label>
                <select name="r" id="search_rating">
                    <option value="">Don't Care</option>
                    <option value="1">1</option>
                    <option value="1.5">1.5</option>
                    <option value="2">2</option>
                    <option value="2.5">2.5</option>
                    <option value="3">3</option>
                    <option value="3.5">3.5</option>
                    <option value="4">4</option>
                    <option value="4.5">4.5</option>
                    <option value="5">5</option>
                </select>
            </div>
        </div>
        <div class="clear"></div>
        <div class="center">
            <input type="submit" value="Search Advanced" class="button" /><br /><br />
        </div>
    </form>
</div>
<?php
$response   = ob_get_contents();
ob_end_clean();

echo $response;
die();
?>
